import json
import sys

import numpy as np
from scipy.fft import dct

# series temp file
series_path = sys.argv[1]

# parse series from json
with open(series_path, "r") as file:
    series = json.load(file)

# get time points and data
data = np.array(series["data"])

# compute discrete cosine transform
data = dct(data)

# update the series
series["data"] = data.tolist()

# store the series to json again
with open(series_path, "w") as file:
    json.dump(series, file, indent=4)
